unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, DB, Menus, IniFiles, ExtCtrls,
  DBTables, DBViewer, Buttons, ComCtrls, ImgList;

type
  TFMain = class(TForm)
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    PopupMenu1: TPopupMenu;
    DBViewer1: TDBViewer;
    QueryInit: TQuery;
    ImageList1: TImageList;
    Splitter1: TSplitter;
    Label2: TLabel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CBxPrimary: TCheckBox;
    CBxForeign: TCheckBox;
    CBxPrefiltered: TCheckBox;
    CBxShowSQL: TCheckBox;
    CBxSelection: TCheckBox;
    CBxShowTree: TCheckBox;
    BatchMove1: TBatchMove;
    TExport: TTable;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    About1: TMenuItem;
    Help1: TMenuItem;
    ShowHints1: TMenuItem;
    Memo1: TMemo;
    Utilities1: TMenuItem;
    Export1: TMenuItem;
    ReadStructure1: TMenuItem;
    CBxOuter: TCheckBox;
    BDEAdmin1: TMenuItem;
    CBxLock: TCheckBox;
    Register1: TMenuItem;
    CBxExtend: TCheckBox;
    DBStruct1: TDBStruct;
    ShowAllTables1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CBxPrimaryClick(Sender: TObject);
    procedure CBxForeignClick(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure CBxShowSQLClick(Sender: TObject);
    procedure DBViewer1AfterOpen(DataSet: TDataSet);
    procedure DBGrid1CellClick(Column: TColumn);
    procedure CBxPrefilteredClick(Sender: TObject);
    procedure DBViewer1Prefiltering(Sender: TObject);
    procedure CBxSelectionClick(Sender: TObject);
    procedure CBxShowTreeClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure DBViewer1TreeLabelClick(FieldIndex: Smallint);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ShowHints1Click(Sender: TObject);
    procedure Read1Click(Sender: TObject);
    procedure CBxOuterClick(Sender: TObject);
    procedure DBViewer1ChangeTableName(Sender: TObject);
    procedure DBViewer1ChangeFieldState(FieldIndex: Smallint;
      visible: Boolean);
    procedure BDEAdmin1Click(Sender: TObject);
    procedure CBxLockClick(Sender: TObject);
    procedure Register1Click(Sender: TObject);
    procedure CBxExtendClick(Sender: TObject);
    procedure DBStruct1SetExtended(Sender: TObject);
    procedure DBStruct1SetOuterJoin(Sender: TObject);
    procedure DBStruct1SetPrefiltered(Sender: TObject);
    procedure DBStruct1SetSelection(Sender: TObject);
    procedure DBStruct1SetShowForeign(Sender: TObject);
    procedure DBStruct1SetShowPrimary(Sender: TObject);
    procedure DBStruct1SetShowSQL(Sender: TObject);
    procedure DBStruct1SetShowTree(Sender: TObject);
    procedure DBStruct1SetTreeLock(Sender: TObject);
    procedure DBViewer1SetExtended(Sender: TObject);
    procedure DBViewer1SetOuterJoin(Sender: TObject);
    procedure DBViewer1SetPrefiltered(Sender: TObject);
    procedure DBViewer1SetSelection(Sender: TObject);
    procedure DBViewer1SetShowForeign(Sender: TObject);
    procedure DBViewer1SetShowPrimary(Sender: TObject);
    procedure DBViewer1SetShowSQL(Sender: TObject);
    procedure DBViewer1SetShowTree(Sender: TObject);
    procedure DBViewer1SetTreeLock(Sender: TObject);
    procedure DBStruct1SetShowAllTables(Sender: TObject);
    procedure ShowAllTables1Click(Sender: TObject);
    procedure DBStruct1ChangeTableName(OldTableName, NewTableName: String);
    procedure DBStruct1HideTable(Sender: TObject; TableName: String);
  private
    { Private declarations }
    IsCtrlKeyDown: Boolean;
  public
    { Public declarations }
  end;

var
  FMain: TFMain;

implementation

uses dbCtrls, bde, shellApi, Registry;

var
  DllPath:string;
  IsFirstTime:boolean;
{$R *.DFM}

procedure TFMain.FormCreate(Sender: TObject);
var
  Regist:TRegistry;
begin
  shortDateFormat:='dd/mm/yyyy';
  Session.GetAliasNames(ComboBox2.items);
  DBGrid1.Hint:='Double-Click : Sort a column'+#10+#13+
                'Ctrl-Double-Click : Sort more columns (Asc/Desc)'+#10+#13+
                'Right-Click  : Modify / Navigate'+#10+#13+
                'Memo and Graphic Fields : Click to view content';
  CBxPrimary.checked:=DBStruct1.showPrimaryKeyFields;
  CBxForeign.checked:=DBStruct1.showForeignKeyFields;
  CBxShowSQL.checked:=DBStruct1.ShowSQL;
  CBxPrefiltered.checked:=DBStruct1.Prefiltered;
  CBxSelection.checked:=DBStruct1.Selection;
  CBxShowTree.checked:=DBStruct1.ShowTree;
  CBxOuter.checked:=DBStruct1.OuterJoin;

  CBxPrimary.enabled:=False;
  CBxForeign.enabled:=False;
  CBxPrefiltered.enabled:=False;
  CBxSelection.enabled:=False;
  CBxShowTree.enabled:=False;
  CBxShowSQL.enabled:=False;
  CBxOuter.enabled:=False;
  CBxLock.enabled:=False;
  CBxExtend.enabled:=False;

  IsFirstTime:=True;
  IsCtrlKeyDown:=False;
  ShowHints1.Checked:=ShowHint;

  // read BDE DLL path
  Regist:=TRegistry.create;
  try
    regist.RootKey:=HKEY_LOCAL_MACHINE;
    Regist.OpenKey('SOFTWARE\Borland\Database Engine',False);
    DllPath:=Regist.ReadString('DLLPATH');
  finally
    Regist.free;
  end;
end;

procedure TFMain.ComboBox1Change(Sender: TObject);
begin
  if ComboBox1.text='' then exit;
  DBViewer1.close;
  DBViewer1.tableName:=DBStruct1.GetTableNameFromTableAlias(ComboBox1.text);
  if DBViewer1.Selection then
    DBViewer1.preOpen
  else
    DBViewer1.open;
end;

procedure TFMain.ComboBox2Change(Sender: TObject);
var
  lpLCData:PChar;
begin
  if DBStruct1.connected then
    DBStruct1.connected:=false;
  DBStruct1.AliasName:=ComboBox2.text;
  try
    DBStruct1.connected:=true;
    // Enables parameters check boxes
    if (session.GetAliasDriverName(DBStruct1.DatabaseName)='ORACLE') then
    // You may choose your national preferences for ORACLE databases.
    // Exemple is given for french language
    begin
      lpLCData:=allocMem(5);
      try
        GetLocaleInfo(LOCALE_USER_DEFAULT,LOCALE_ILANGUAGE,lpLCData,5);
        // if language is french
        if lpLCData='040c' then
        begin
          QueryInit.SQL.Text := 'ALTER SESSION SET NLS_TERRITORY = ''FRANCE''';
          QueryInit.ExecSQL;
          QueryInit.SQL.Text := 'ALTER SESSION SET NLS_LANGUAGE = ''FRENCH''';
          QueryInit.ExecSQL;
          QueryInit.SQL.Text := 'ALTER SESSION SET NLS_DATE_FORMAT = ''DD/MM/YYYY''';
          QueryInit.ExecSQL;
        end;
      finally
        freeMem(lpLCData);
      end;
    end;
    DBStruct1.GetTableNames(ComboBox1.items);
  except
    on EDatabaseError do
    begin
      ComboBox1.items.clear;
      raise;
    end;
  end;
  ComboBox1.text:='';
  if IsFirstTime then
  begin
    IsFirstTime:=False;
    CBxPrimary.enabled:=True;
    CBxForeign.enabled:=True;
    CBxPrefiltered.enabled:=True;
    CBxSelection.enabled:=True;
    CBxShowTree.enabled:=True;
    CBxShowSQL.enabled:=True;
    CBxOuter.enabled:=True;
    CBxLock.enabled:=True;
    CBxExtend.enabled:=True;
  end;
end;

procedure TFMain.DBGrid1DblClick(Sender: TObject);
var
  FieldIndex:smallint;
begin
  if not DBViewer1.active then exit;
  FieldIndex:=(Sender as TDBGrid).selectedindex;
  if ((Sender as TDBGrid).selectedField.DataType in
    [ftMemo,ftBlob,ftGraphic,ftFmtMemo,ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor])
     then exit; // non sortable data types
  if not IsCtrlKeyDown then
    DBViewer1.orderFields.clear;
  // reverse order if order is already on this field
  if (DBViewer1.OrderFields.count>0) and (DBViewer1.OrderFields.indexOf(DBViewer1.FieldLabels[DBGrid1.selectedField.FieldNo-1])<>-1) then
    DBViewer1.OrderDesc:=not DBViewer1.OrderDesc
  else
    DBViewer1.orderFields.add(DBViewer1.FieldLabels[DBGrid1.selectedField.FieldNo-1]);
  DBViewer1.RefreshView;
  (Sender as TDBGrid).selectedIndex:=FieldIndex;
end;

procedure TFMain.DBViewer1AfterOpen(DataSet: TDataSet);
begin
  Memo1.lines.assign(DBViewer1.Trace);
end;

procedure TFMain.DBGrid1CellClick(Column: TColumn);
begin
  DBViewer1.EditField(Column);
end;

procedure TFMain.DBViewer1Prefiltering(Sender: TObject);
begin
  Memo1.lines.assign(DBViewer1.Trace);
end;

procedure TFMain.CBxPrimaryClick(Sender: TObject);
begin
  DBStruct1.showPrimaryKeyFields:=CBxPrimary.checked;
end;

procedure TFMain.CBxForeignClick(Sender: TObject);
begin
  DBStruct1.showForeignKeyFields:=CBxForeign.checked;
end;

procedure TFMain.CBxShowSQLClick(Sender: TObject);
begin
  DBStruct1.ShowSQL:=(Sender as TCheckBox).checked;
end;

procedure TFMain.CBxPrefilteredClick(Sender: TObject);
begin
  DBStruct1.Prefiltered:=(Sender as TCheckBox).Checked;
end;

procedure TFMain.CBxSelectionClick(Sender: TObject);
begin
  DBStruct1.Selection:=(Sender as TCheckBox).Checked;
end;

procedure TFMain.CBxShowTreeClick(Sender: TObject);
begin
  DBStruct1.ShowTree:=(Sender as TCheckBox).checked;
end;

procedure TFMain.CBxLockClick(Sender: TObject);
begin
  DBStruct1.TreeLocked:=(Sender as TCheckBox).checked;
end;

procedure TFMain.DBStruct1SetSelection(Sender: TObject);
begin
  CBxSelection.checked:=DBStruct1.Selection;
end;

procedure TFMain.DBStruct1SetOuterJoin(Sender: TObject);
begin
  CBxOuter.checked:=DBStruct1.OuterJoin;
end;

procedure TFMain.DBStruct1SetShowTree(Sender: TObject);
begin
  CBxShowTree.checked:=DBStruct1.ShowTree;
end;

procedure TFMain.DBStruct1SetExtended(Sender: TObject);
var
  memTableName:string;
  i:integer;
begin
  CBxExtend.checked:=DBStruct1.Extended;
  if DBStruct1.extended then
  begin
    memTableName:=ComboBox1.Text;
    DBStruct1.GetTableNames(ComboBox1.items);
    for i:=0 to ComboBox1.items.count-1 do
    begin
      if DBStruct1.GetTableNameFromTableAlias(ComboBox1.items[i])=memTableName then
      begin
        ComboBox1.itemIndex:=i;
        break;
      end;
    end;
  end
  else
  begin
    memTableName:=DBStruct1.GetTableNameFromTableAlias(ComboBox1.Text);
    DBStruct1.GetTableNames(ComboBox1.items);
    ComboBox1.itemIndex:=ComboBox1.items.indexOf(memTableName);
  end;
end;

procedure TFMain.DBStruct1SetPrefiltered(Sender: TObject);
begin
  CBxPrefiltered.checked:=DBStruct1.Prefiltered;
end;

procedure TFMain.DBStruct1SetShowForeign(Sender: TObject);
begin
  CBxForeign.checked:=DBStruct1.ShowForeignKeyFields;
end;

procedure TFMain.DBStruct1SetShowPrimary(Sender: TObject);
begin
  CBxPrimary.checked:=DBStruct1.ShowPrimaryKeyFields;
end;

procedure TFMain.DBStruct1SetShowSQL(Sender: TObject);
begin
  CBxShowSQL.checked:=DBStruct1.ShowSQL;
end;

procedure TFMain.DBStruct1SetTreeLock(Sender: TObject);
begin
  CBxLock.checked:=DBStruct1.TreeLocked;
end;

procedure TFMain.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure TFMain.Export1Click(Sender: TObject);
var
  posit:shortInt;
  i:integer;
begin
  if (not DBViewer1.active) or (DBViewer1.isEmpty) then
  begin
    ShowMessage('Nothing to do !');
    exit;
  end;
  posit:=pos('.',DBViewer1.tableName);
  if posit<>0 then
    SaveDialog1.FileName:=copy(DBViewer1.tableName,1,posit-1)+'.txt'
  else
    SaveDialog1.FileName:=DBViewer1.tableName+'.txt';
  if not SaveDialog1.execute then exit;
  TExport.tableName:=SaveDialog1.FileName;

  BatchMove1.mappings.clear;
  for i:=0 to DBViewer1.FieldCount-1 do
    if not(DBViewer1.Fields[i].DataType in
      [ftMemo,ftBlob,ftGraphic,ftFmtMemo,ftParadoxOle, ftDBaseOle, ftTypedBinary, ftCursor]) and
       (DBViewer1.Fields[i].visible) then
      BatchMove1.mappings.add(DBViewer1.Fields[i].FieldName);
  BatchMove1.execute;
end;

procedure TFMain.About1Click(Sender: TObject);
begin
  ShowMessage('Demo of DBViewer release '+intToStr(DBStruct1.Release)+'.'+intToStr(DBStruct1.SubRelease));
end;

procedure TFMain.DBViewer1TreeLabelClick(FieldIndex: Smallint);
begin
  DBGrid1.SelectedField:=DBViewer1.Fields[FieldIndex];
  DBGrid1.SetFocus;
end;

procedure TFMain.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_CONTROL then
    IsCtrlKeyDown:=True;
end;

procedure TFMain.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_CONTROL then
    IsCtrlKeyDown:=False;
end;

procedure TFMain.ShowHints1Click(Sender: TObject);
begin
  (Sender as TMenuItem).Checked:=not (Sender as TMenuItem).Checked;
  FMain.ShowHint:=(Sender as TMenuItem).Checked;
  DBViewer1.ShowHint:=FMain.ShowHint;
end;

procedure TFMain.Read1Click(Sender: TObject);
begin
  DBStruct1.ForceReadStructure;
  DBStruct1.GetTableNames(ComboBox1.items);
end;

procedure TFMain.CBxOuterClick(Sender: TObject);
begin
  DBStruct1.OuterJoin:=(Sender as TCheckBox).Checked;
end;

procedure TFMain.CBxExtendClick(Sender: TObject);
begin
  DBStruct1.Extended:=(Sender as TCheckBox).checked;
end;

procedure TFMain.DBViewer1ChangeTableName(Sender: TObject);
begin
  ComboBox1.itemIndex:=ComboBox1.items.indexOf(DBViewer1.TableAlias);
end;

procedure TFMain.DBViewer1ChangeFieldState(FieldIndex: Smallint;
  visible: Boolean);
begin
  if not DBViewer1.active then exit;
  if FieldIndex=-1 then exit;
  if visible then
  begin
    DBGrid1.SelectedField:=DBViewer1.Fields[FieldIndex];
    DBGrid1.SetFocus;
  end;
end;

procedure TFMain.BDEAdmin1Click(Sender: TObject);
var
  p:smallInt;
begin
  p:=pos(';',DllPath);
  if p<>0 then
    DllPath:=copy(DllPath,1,p-1);
  ShellExecute(Application.MainForm.Handle, nil,PChar(DllPath+'\BDEadmin.exe'),nil,nil,SW_SHOW);
end;

procedure TFMain.Register1Click(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.Registration;
end;

procedure TFMain.DBViewer1SetExtended(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.Extended:=DBViewer1.extended;
end;

procedure TFMain.DBViewer1SetOuterJoin(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.OuterJoin:=DBViewer1.OuterJoin;
end;

procedure TFMain.DBViewer1SetPrefiltered(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.Prefiltered:=DBViewer1.Prefiltered;
end;

procedure TFMain.DBViewer1SetSelection(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.Selection:=DBViewer1.Selection;
end;

procedure TFMain.DBViewer1SetShowForeign(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.ShowForeignKeyFields:=DBViewer1.ShowForeignKeyFields;
end;

procedure TFMain.DBViewer1SetShowPrimary(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.ShowPrimaryKeyFields:=DBViewer1.ShowPrimaryKeyFields;
end;

procedure TFMain.DBViewer1SetShowSQL(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.ShowSQL:=DBViewer1.ShowSQL;
end;

procedure TFMain.DBViewer1SetShowTree(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.ShowTree:=DBViewer1.ShowTree;
end;

procedure TFMain.DBViewer1SetTreeLock(Sender: TObject);
begin
  if DBStruct1<>nil then
    DBStruct1.TreeLocked:=DBViewer1.TreeLocked;
end;

procedure TFMain.DBStruct1SetShowAllTables(Sender: TObject);
var
  memText:string;
  posit:smallInt;
begin
  memText:=ComboBox1.text;
  DBStruct1.GetTableNames(ComboBox1.items);
  posit:=ComboBox1.items.indexOf(memText);
  if posit=-1 then
  begin
    ComboBox1.text:='';
    DBViewer1.close;
  end
  else
    ComboBox1.itemIndex:=posit;
  ShowAllTables1.Checked:=DBStruct1.ShowAllTables;
end;

procedure TFMain.ShowAllTables1Click(Sender: TObject);
begin
  DBStruct1.ShowAllTables:=not(Sender as TMenuItem).Checked;
end;

procedure TFMain.DBStruct1ChangeTableName(OldTableName,NewTableName: String);
begin
  ComboBox1.items.delete(ComboBox1.items.indexOf(OldTableName));
  ComboBox1.itemIndex:=ComboBox1.items.add(NewTableName);
end;

procedure TFMain.DBStruct1HideTable(Sender: TObject; TableName: String);
begin
  if not DBStruct1.ShowAllTables then
    if MessageDlg('This will remove this table from the table list.'+#10#13+
                  'To show it again you will have to set the Utility/Show All Tables menu option.'+#10#13+
                  'Do you want to continue ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
    begin
      ComboBox1.items.delete(ComboBox1.itemIndex);
      DBViewer1.close;
    end;
end;

end.
